package easik;

import java.util.ArrayList;
import java.util.HashMap;

import easik.sketch.datatype.DataType;


/**
 * This class contains constants used throughout the JEase project
 * 
 * @author Kevin Green 2006
 * @author Vera Ranieri 2006
 * @version 2006-08-21 Kevin Green
 */
public class EasikConstants {
	
	/**
	 * File extension for XML
	 */
	public static final String XML_FILE = ".xml"; 
	/**
	 * File extnsion for TeX
	 */
	public static final String TEX_FILE = ".tex"; 
	/**
	 * File extension for SQL text files
	 */
	public static final String SQL_FILE = ".sql";
	
	/**
	 * Array of MySQL primitive types
	 */
	public static final String[] MY_SQL_TYPES=
		{"VARCHAR(255)", "DATE", "DATETIME", "TIMESTAMP", "TIME", "INT", "DOUBLE", "BLOB", "TEXT", "BOOL"}; 
	/**
	 * Default MySQL data type, currently VARCHAR(255)
	 */
	public static final String MY_SQL_DEFAULT = "VARCHAR(255)"; 
	
	/**
	 * Array of Oracle primitive types
	 */
	public static final String[] ORACLE_TYPES=
		{"VARCHAR2(255)", "DATE", "TIMESTAMP", "INT", "DOUBLE PRECISION", "BLOB", "CLOB", "BOOLEAN"}; 
	/**
	 * Default Oracle data type, currently VARCHAR2(255)
	 */
	public static final String ORACLE_DEFAULT = "VARCHAR2(255)"; 
	
	/**
	 * Array of DB2 primitive types
	 */
	public static final String[] DB2_TYPES=
		{"VARCHAR(255)", "DATE", "TIMESTAMP", "TIME", "INT", "DOUBLE PRECISION", "BLOB", "CLOB", "SMALLINT"}; 
	/**
	 * Default DB2 data type, currently VARCHAR(255)
	 */
	public static final String DB2_DEFAULT = "VARCHAR(255)";
	
	/**
	 * Array of XML primitive types
	 */
	public static final String[] XML_TYPES=
		{"string", "date", "dateTime", "int", "time", "int", "double", "base64binary", "hexBinary", "string", "boolean"};
	/**
	 * Default XML data type, currently <it>string</it>
	 */
	public static final String XML_DEFAULT = "string"; //Default XML data type
	
	/**
	 * Method to get an ordered array with the default data type
	 * names. Used to sort the datatypes for display
	 * 
	 * @return An ordered ArrayList of the default data type names.
	 */
	public static ArrayList<String> getDefaultDataTypesOrder(){
		ArrayList<String> myArr = new ArrayList<String>();
		myArr.add("VarChar(255)");
		myArr.add("Integer");
		myArr.add("Boolean");
		myArr.add("Text");
		myArr.add("Blob");
		myArr.add("Timestamp");
		myArr.add("Date");
		myArr.add("DateTime");
		myArr.add("Time");
		myArr.add("Double");
		return myArr;
	}
	
	/**
	 * Method to get a standard set of data types
	 * 
	 * @return HashMap of the standard data types set
	 */
	public static HashMap getDefaultDataTypes(){
		HashMap<String, DataType> myArr = new HashMap<String, DataType>();
		
		myArr.put("Date", new DataType("Date", "A date.", "DATE", "DATE", "DATE", "date", "Date"));
		myArr.put("DateTime", new DataType("DateTime", "A date and time.", "DATETIME", "TIMESTAMP", "TIMESTAMP", "dateTime", "DateTime"));
		myArr.put("Timestamp", new DataType("Timestamp", "A UNIX timestamp.", "TIMESTAMP", "TIMESTAMP", "TIMESTAMP", "int", "Timestamp"));
		myArr.put("Time", new DataType("Time", "A time.", "TIME", "TIMESTAMP", "TIME", "time", "Time"));
		myArr.put("Integer", new DataType("Integer", "An integer.", "INT", "INT", "INT", "int", "Integer"));
		myArr.put("Double", new DataType("Double", "A double.", "DOUBLE", "DOUBLE PRECISION", "DOUBLE PRECISION", "double", "Double"));
		myArr.put("VarChar(255)", new DataType("VarChar(255)", "A 255 character string.", "VARCHAR(255)", "VARCHAR2(255)", "VARCHAR(255)", "string", "VarChar(255)"));
		myArr.put("Blob", new DataType("Blob", "A binary data object.", "BLOB", "BLOB", "BLOB", "base64binary", "Blob"));
		myArr.put("Text", new DataType("Text", "A large block of text.", "TEXT", "CLOB", "CLOB", "string", "Text"));
		myArr.put("Boolean", new DataType("Boolean", "A boolean value.", "BOOL", "BOOLEAN", "SMALLINT", "boolean", "Boolean"));
		
		return myArr;
	}
}
